extends Node2D


func _ready() -> void:
	position.x = float(DisplayServer.window_get_size().x) / 2
	position.y = float(DisplayServer.window_get_size().y) / 2


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("koniec"):
		get_tree().quit()
		
	if Input.is_action_pressed("ui_left"):
		rotation -= PI * delta
	if Input.is_action_pressed("ui_right"):
		rotation += PI * delta
		
	if Input.is_action_pressed("ui_up"):
		position += Vector2.UP.rotated(rotation) * 100 * delta
	if Input.is_action_pressed("ui_down"):
		position += Vector2.DOWN.rotated(rotation) * 100 * delta
