extends CharacterBody2D

@onready var animated_sprite_2d: AnimatedSprite2D = $AnimatedSprite2D

var kierunek_czolgu := Vector2.RIGHT
var predkosc_jazdy := 50
var predkosc_obrotu := 2

func _ready() -> void:
	position.x = float(DisplayServer.window_get_size().x) / 2
	position.y = float(DisplayServer.window_get_size().y) / 2
	animated_sprite_2d.play("postoj")


func _physics_process(delta: float) -> void:
	
	var czy_jedzie: bool = false
	var kierunek_z_klawiatury := Input.get_vector("ui_left","ui_right","ui_down","ui_up")
	
	if kierunek_z_klawiatury.x != 0:
		kierunek_czolgu = kierunek_czolgu.rotated(kierunek_z_klawiatury.x * (PI/2) * predkosc_obrotu * delta)
		rotation = kierunek_czolgu.angle()
	if kierunek_z_klawiatury.y != 0:
		velocity = lerp(velocity,(kierunek_czolgu.normalized() * kierunek_z_klawiatury.y) * predkosc_jazdy, delta * predkosc_jazdy)
	else:
		velocity = Vector2.ZERO
	
	move_and_slide()
	
	if Input.is_action_just_pressed("koniec"):
		get_tree().quit()

	if Input.is_action_pressed("ui_left"):
		animated_sprite_2d.play("w_lewo")
		czy_jedzie = true
	elif Input.is_action_pressed("ui_right"):
		animated_sprite_2d.play("w_prawo")
		czy_jedzie = true

	if Input.is_action_pressed("ui_up"):
		if not czy_jedzie:
			animated_sprite_2d.play("do_przodu")
		czy_jedzie = true
	elif Input.is_action_pressed("ui_down"):
		if not czy_jedzie:
			animated_sprite_2d.play("do_tylu")
		czy_jedzie = true
		
	if not czy_jedzie:
		animated_sprite_2d.play("postoj")
